<?php
/*Metabox Postype Testimonial*/
add_action( 'add_meta_boxes', 'add_metabox_admin' );
function add_metabox_admin(){
    if ( isset( $GLOBALS['post_type'] ) && in_array( $GLOBALS['post_type'], array('testimonial') ) ) {
        add_meta_box(
            'field_testimonial',
            'Info',
            'render_content_testimonial',
            'testimonial',
            'normal',
            'high'
        );
    }
    if ( isset( $GLOBALS['post_type'] ) && in_array( $GLOBALS['post_type'], array('team') ) ) {
        add_meta_box(
            'field_team',
            'Info',
            'render_content_team',
            'team',
            'normal',
            'high'
        );
    }

}

/*Metabox Testimonial*/
function render_content_testimonial(){
    global $post;
    $business = get_post_meta( $post->ID, 'business', true );
    ?>
    <div class="inside">
        <div  class="setting_text" id="slide_template_text"><?php esc_html_e( 'Business', 'automatic' );?></div>
        <input type="text" name="txtbusiness" value="<?php echo esc_attr($business); ?>">
    </div>
    <?php
}

/*Metabox Team*/
function render_content_team(){
    global $post;
    $position = get_post_meta( $post->ID, 'position', true );
    $facebook = get_post_meta( $post->ID, 'facebook', true );
    $twitter = get_post_meta( $post->ID, 'twitter', true );
    $instagram = get_post_meta( $post->ID, 'instagram', true );
    $gpl = get_post_meta( $post->ID, 'googleplus', true );
    ?>
    <div class="inside">
        <div  class="setting_text" id="slide_template_text"><?php esc_html_e( 'Position', 'automatic' );?></div>
        <input type="text" name="txtposition" value="<?php echo esc_attr($position); ?>">
    </div>
    <div class="inside">
        <div  class="setting_text" id="slide_template_text"><?php esc_html_e( 'Facebook', 'automatic' );?></div>
        <input type="text" name="txtfacebook" value="<?php echo esc_attr($facebook); ?>">
    </div>
    <div class="inside">
        <div  class="setting_text" id="slide_template_text"><?php esc_html_e( 'Twitter', 'automatic' );?></div>
        <input type="text" name="txttwitter" value="<?php echo esc_attr($twitter); ?>">
    </div>
    <div class="inside">
        <div  class="setting_text" id="slide_template_text"><?php esc_html_e( 'Instagram', 'automatic' );?></div>
        <input type="text" name="txtinstagram" value="<?php echo esc_attr($instagram); ?>">
    </div>
    <div class="inside">
        <div  class="setting_text" id="slide_template_text"><?php esc_html_e( 'Google plus', 'automatic' );?></div>
        <input type="text" name="txtgpl" value="<?php echo esc_attr($gpl); ?>">
    </div>
    <div class="inside">
        <p class="description"><?php esc_html_e('Add link social for team','automatic')?></p>
    </div>
    <?php
}
/*Save metabox*/
add_action( 'save_post','save_metabox_team' );
function save_metabox_team($post_id){
    $job = isset($_POST['txtbusiness']) ? $_POST['txtbusiness'] : '';

    $position = isset($_POST['txtposition']) ? $_POST['txtposition'] : '';
    $facebook = isset($_POST['txtfacebook']) ? $_POST['txtfacebook'] : '';
    $twitter = isset($_POST['txttwitter']) ? $_POST['txttwitter'] : '';
    $instagram = isset($_POST['txtinstagram']) ? $_POST['txtinstagram'] : '';
    $gpl = isset($_POST['txtgpl']) ? $_POST['txtgpl'] : '';
    /**
     * Update info testimonial
     */
    update_post_meta($post_id,'business',$job);
    /**
     * Update info team
     */
    update_post_meta($post_id,'position',$position);
    update_post_meta($post_id,'facebook',$facebook);
    update_post_meta($post_id,'twitter',$twitter);
    update_post_meta($post_id,'instagram',$instagram);
    update_post_meta($post_id,'googleplus',$gpl);
}